/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.items;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dries007.tfc.api.types.ICrop;
import net.dries007.tfc.objects.blocks.agriculture.BlockCropTFC;
import net.dries007.tfc.objects.blocks.stone.BlockFarmlandTFC;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemSeedsTFC
extends Item
implements IPlantable {
    private static final Map<ICrop, ItemSeedsTFC> MAP = new HashMap<ICrop, ItemSeedsTFC>();
    private final ICrop crop;

    public static ItemSeedsTFC get(ICrop crop) {
        return MAP.get(crop);
    }

    public static ItemStack get(ICrop crop, int amount) {
        return new ItemStack((Item)MAP.get(crop), amount);
    }

    public ItemSeedsTFC(ICrop crop) {
        this.crop = crop;
        if (MAP.put(crop, this) != null) {
            throw new IllegalStateException("There can only be one.");
        }
    }

    @Nonnull
    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack itemstack = player.func_184586_b(hand);
        IBlockState state = worldIn.func_180495_p(pos);
        if (facing == EnumFacing.UP && player.func_175151_a(pos.func_177972_a(facing), facing, itemstack) && state.func_177230_c().canSustainPlant(state, (IBlockAccess)worldIn, pos, EnumFacing.UP, (IPlantable)this) && worldIn.func_175623_d(pos.func_177984_a()) && state.func_177230_c() instanceof BlockFarmlandTFC) {
            worldIn.func_175656_a(pos.func_177984_a(), BlockCropTFC.get(this.crop).func_176223_P());
            if (player instanceof EntityPlayerMP) {
                CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos.func_177984_a(), itemstack);
            }
            itemstack.func_190918_g(1);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return EnumPlantType.Crop;
    }

    public IBlockState getPlant(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() instanceof BlockCropTFC && ((BlockCropTFC)state.func_177230_c()).getCrop() == this.crop) {
            return state;
        }
        return BlockCropTFC.get(this.crop).func_176223_P();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        this.crop.addInfo(stack, worldIn, tooltip, flagIn);
    }
}

